class TeamspeakMutator extends Mutator config(Teamspeak);

// ---------------------------------------------------------------------------------
// TeamSpeak Mutator v03c
// ---------------------------------------------------------------------------------
// Enables a player to connect to a teamspeak server ingame using the commands:
// "mutate teamspeak" to connect to their respective team-subchannel
// "mutate tsb" to connect to the blueteam-subchannel
// "mutate tsr" to connect to the redteam-subchannel
// "mutate tst" to connect to the together-subchannel
// "mutate tss" to connect to the spectator-subchannel
// "mutate tch channelname" to connect to the channel "channelname"
//
// Bugs:
// - When you are allready connected to the server, and enter unreal and use the mutator
//   to enter a channel and it fails, you have to type the mutator command again. 
//   This is because the first time it tries to connect it uses the password to connect.
//   After that it doesn't send the serverpassword anymore, see changes in v3c.
// - When using a password on the channel, you can only connect to the given channel
//   the first time. After that, it doesn't work anymore due to a bug in the TS client.
// 
//   I've informed the TS devs about these bugs, i hope they fix it soon.. 
//
//
// Changes by smaankerezz in v3c
// - the server password is only send to the teamspeak client the first time instead of 
//   each time a player connects. This is due to a bug in TS. 
// - fixed the error in the teamspeak.ini

// Changes by smaankerezz in v3b
// - settings from the ini file are properly loaded, thnx rednas :)
// - two configurable welcome messages depending on whether or not bEnableCommands 
//   is set to true.
//
// Changes by smaankerezz since v2 by rednas & idefix:
// - a player can also connect to a channel of their own choice using tch
// - shows the player to which server, channel and subchannel it is connecting
// - added the playername characters {}<>`+| also to be changed into "" 
// - changed the channeling a bit 
//
// ---------------------------------------------------------------------------------

var globalconfig string Server;
var globalconfig int Port;
var globalconfig string Password;
var globalconfig string Channel;
var globalconfig string ChannelPassword;
var globalconfig string Prefix;
var globalconfig string Subchannel[4];
var globalconfig bool bEnableCommands;
var globalconfig string WelcomeMsgCmdEnabledLine1;
var globalconfig string WelcomeMsgCmdEnabledLine2;
var globalconfig string WelcomeMsgCmdEnabledLine3;
var globalconfig string WelcomeMsgCmdEnabledLine4;
var globalconfig string WelcomeMsgCmdEnabledLine5;
var globalconfig string WelcomeMsgCmdEnabledLine6;
var globalconfig string WelcomeMsgCmdDisabledLine1;
var globalconfig string WelcomeMsgCmdDisabledLine2;
var globalconfig string WelcomeMsgCmdDisabledLine3;
var globalconfig string WelcomeMsgCmdDisabledLine4;
var globalconfig string WelcomeMsgCmdDisabledLine5;
var globalconfig string WelcomeMsgCmdDisabledLine6;

var bool Initialised;
var float LastTime;
var bool bGameStarted;

struct stPlayerInfo { var Pawn Pawn; var bool bInformed; };

var stPlayerInfo PlayerInfo[32];
var bool bInitialised;
var int CurrentID;

var int	aiServerPwGiven[32];	// To check if the channel password has allready been given to the TS client
var int	aiChannelPwGiven[32];	// To check if the subchannel password has allready been given to the TS client

function PostBeginPlay() {
	local int index;

	if (!bInitialised) {
		bInitialised = true;
		Level.Game.RegisterMessageMutator(Self);
		bGameStarted = false;
		Enable('Tick');
		for ( index=0; index<32; index++ )
		{
			aiServerPwGiven[index] = 0;
			aiChannelPwGiven[index] = 0;
		}
		//bGameStart = false;
		//bEndGame = false;
		log("TeamspeakMutator running...");
		return;
	}
	Level.Game.RegisterMessageMutator(Self);
	log("TeamspeakMutator ALLREADY running...");

	if ( NextMutator!= None ) { 
		NextMutator.PostBeginPlay(); 
	}
}

function InitPlayerInfo(Pawn p) {
	local int index;
	for (index=0; index<32; index++) {
		if (PlayerInfo[index].Pawn==None) {
			PlayerInfo[index].Pawn = p;
			PlayerInfo[index].bInformed = false;
			return;
		}
	}
}

function Mutate(string MutateString, PlayerPawn Sender)
{
	local string params;
	local string sChannelName;
	local int iChannelLength;

	sChannelName = "";

	if ( (!Sender.IsA('Bot')) && (Sender.PlayerReplicationInfo != None) && (Sender.PlayerReplicationInfo.Team != 255) )
	{
		// goto respective color channel
		if (Left(Caps(MutateString),9) == "TEAMSPEAK")
		{
			StartTS(Sender, -1, sChannelName);
			return;
		}

		if (bEnableCommands) {
			// goto given channelname
			if (Left(Caps(MutateString),3) == "TCH")
			{
				iChannelLength = Len (MutateString)-4;
				sChannelName = Right(MutateString,iChannelLength);
				StartTS(Sender, -1, sChannelName);
				return;
			}
			// goto predefined channel
			else if (Left(Caps(MutateString),3) == "TSR")
			{
				StartTS(Sender, 0, sChannelName);
				return;
			}
			else if (Left(Caps(MutateString),3) == "TSB")
			{
				StartTS(Sender, 1, sChannelName);
				return;
			}
			else if (Left(Caps(MutateString),3) == "TSS")
			{
				StartTS(Sender, 2, sChannelName);
				return;
			}
			else if (Left(Caps(MutateString),3) == "TST")
			{
				StartTS(Sender, 3, sChannelName);
				return;
			}
		}
	}

	if (NextMutator != None) {
		NextMutator.Mutate(MutateString, Sender);
	}

}

function Tick(float DeltaTime)
{
    local Pawn p;

	Super.tick(DeltaTime);
    // if (LastTime == Level.TimeSeconds) { LastTime = Level.TimeSeconds; return; };

	bGameStarted = true;
	//Disable('Tick');


    if (Level.Game.CurrentID > CurrentID) {
            for (p=Level.PawnList; p!=None; p=p.NextPawn) {
               if (p.PlayerReplicationInfo.PlayerID==CurrentID) {
                  if ( (p.PlayerReplicationInfo!=None)  && (!p.IsA('Bot'))  ) { //&& (!p.PlayerReplicationInfo.bIsSpectator) ) { //(!p.IsA('Bot')) &&
                    InitPlayerInfo(p);
                    }
                    CurrentID++;
                    break;
                   }
               }
    }
    if (LastTime == Level.TimeSeconds) { LastTime = Level.TimeSeconds; return; };
    /*
	// Check for new players
	if(Level.Game.CurrentID > CurrentID)
	{
		for(p=Level.PawnList; p!=None; p=p.NextPawn)
		{
			if ( (!p.IsA('Bot')) && (p.PlayerReplicationInfo != None) && (p.PlayerReplicationInfo.Team != 255) )
			{
				StartTS(p);
			}
			break;
		}
		CurrentID++;
	}
	*/
}

function StartTS(Pawn p, int iSubChan, string sChannelName)
{
	local TeamspeakInfo a;
	local string params;
	local string sChannel;
	local string sSubChannel;
	local bool bAltnernativeChannel;

	local string sServerInfo;
	local string sChannelInfo;
	local string sSubChannelInfo;

	//log("playerid for ts: " @p.PlayerReplicationInfo.PlayerId);
	
	// ------------------------------------------------------------
	// determine channel, subchannel to connect to
	// ------------------------------------------------------------

	if(iSubChan==-1) {
		// connect to user specified channel
		if (Len(sChannelName)>0) {
			sChannel = sChannelName;
			sSubChannel = "";
			bAltnernativeChannel = True;
			//log("user specified channel");
		}
		// connect to playerteam color subchannel
		else {
			sChannel	= Channel;
			sSubChannel = Subchannel[ PlayerPawn(p).PlayerReplicationInfo.Team ];
			bAltnernativeChannel = False;
			//log("connect to colorchannel:" @sChannel $" sub:" @sSubChannel $" team:" @PlayerPawn(p).PlayerReplicationInfo.Team);
		}
	} 
	else {
		// connect to given subchannel
		sChannel	= Channel;
		sSubChannel = Subchannel[iSubChan];
		bAltnernativeChannel = False;
	}

	// ------------------------------------------------------------
	// create the url to which we are going to connect to
	// ------------------------------------------------------------

	params = "teamspeak://" $ Server $ ":" $ Port;

	// Check if the server password has allready been given this session
	// since we only have to give it the first time the player connects
	if ( Password != "" && aiServerPwGiven [ p.PlayerReplicationInfo.PlayerId ] == 0 ) 
	{
		aiServerPwGiven [ p.PlayerReplicationInfo.PlayerId ] = 1;
		params = params $ "?password=" $ Password;
	}
	params = params $ "?nickname=" $ Prefix $ ConvertToNormalText(PlayerPawn(p).PlayerReplicationInfo.PlayerName);
	params = params $ "?channel=" $ sChannel;

	// Passwords have no relevance with user specified channel or when it's empty
	if ( !bAltnernativeChannel && ChannelPassword != "" ) {

		// Check if the channel password has allready been given this session
		// since we only have to give it the first time the player connects
		if ( aiChannelPwGiven [ p.PlayerReplicationInfo.PlayerId ] == 0 )
		{
			aiChannelPwGiven [ p.PlayerReplicationInfo.PlayerId ] = 1;
			params = params $ "?channelpassword=" $ ChannelPassword;
		}
	}
	// Subchannels have no relevance with user specified channel
	if ( !bAltnernativeChannel && sSubChannel != "" )	{
		params = params $ "?subchannel=" $ sSubChannel;
	}

	// ------------------------------------------------------------
	// create status info which is displayed to the player
	// ------------------------------------------------------------

	sServerInfo		= "  > server: " $ Server $ ":" $ Port;
	sChannelInfo	= "  > channel: " $ sChannel;
	if (sSubChannel != "") {
		sSubChannelInfo = "  > subchannel: " $ sSubChannel;
	}

	a = Spawn(class'TeamspeakInfo',p,,p.Location);
	if (a != None) {
		log("TS url: " @params);
		a.sURL = params;
		a.StartTS(sServerInfo, sChannelInfo, sSubChannelInfo);
	}
}

function string ConvertToNormalText(string sText)
{

	local int iLength;
	local int i;
	local string sTemp;
	local string sChar;
	local int iCharCode;

	iLength = Len(sText);
	if (iLength > 0)
	{
		sTemp = "";
		for (i=0; i<iLength; i++)
		{
			sChar = Mid(sText, i, 1);
			iCharCode = asc(sChar);

			if ( (iCharCode == Clamp(iCharCode, 192, 198)) || (iCharCode == Clamp(iCharCode, 224, 230)) )
			{
				sChar = "a";
			}
			else if ( (iCharCode == Clamp(iCharCode, 200, 203)) || (iCharCode == Clamp(iCharCode, 232, 235)) )
			{
				sChar = "e";
			}
			else if ( (iCharCode == Clamp(iCharCode, 204, 207)) || (iCharCode == Clamp(iCharCode, 236, 239)) )
			{
				sChar = "i";
			}
			else if ( (iCharCode == Clamp(iCharCode, 210, 214)) || (iCharCode == Clamp(iCharCode, 242, 246)) || (sChar == chr(216)) || (sChar == chr(248)) || (sChar == chr(240)) )
			{
				sChar = "o";
			}
			else if ( (iCharCode == Clamp(iCharCode, 217, 220)) || (iCharCode == Clamp(iCharCode, 249, 252)) )
			{
				sChar = "u";
			}
			else if ( (sChar == chr(199)) || (sChar == chr(231)) )
			{
				sChar = "c";
			}
			else if (sChar == chr(208))
			{
				sChar = "d";
			}
			else if ( (sChar == chr(209)) || (sChar == chr(241)) )
			{
				sChar = "n";
			}
			else if (sChar == chr(215))
			{
				sChar = "x";
			}
			else if ( (sChar == chr(221)) || (sChar == chr(255)) || (sChar == chr(253)) )
			{
				sChar = "y";
			}
			else if ( (sChar == chr(203)) || (sChar == chr(254)) )
			{
				sChar = "b"; // or S
			}

			if (InStr(" !@#$%^&*-_=';:,.?[]/\~(){}<>`+|", sChar) != -1)
			{
				sChar = "";
			}

			sTemp = sTemp $ sChar;
		}

		return (sTemp);

	}

	return (sText);
}

function ModifyPlayer(Pawn Other) 
{
	local int i,j;

	if (Other == None || !Other.bIsPlayer || !Other.IsA('PlayerPawn')) { return; }

	for (i=0; i<32; i++) {
		if (PlayerInfo[i].Pawn == Other) {
			if (!PlayerInfo[i].bInformed ) {
				ShowWelcomeMessage(Other, bEnableCommands);
				PlayerInfo[i].bInformed = true;
				return;
			}
		}
	}

	if ( NextMutator!= None ) { 
		NextMutator.ModifyPlayer(Other); 
	}

}

function ShowWelcomeMessage (Pawn Other, bool bEnableCommands)
{
	if(bEnableCommands) {
		if (WelcomeMsgCmdEnabledLine1 != "")
			Other.ClientMessage(WelcomeMsgCmdEnabledLine1);
		if (WelcomeMsgCmdEnabledLine2 != "")
			Other.ClientMessage(WelcomeMsgCmdEnabledLine2);
		if (WelcomeMsgCmdEnabledLine3 != "")
			Other.ClientMessage(WelcomeMsgCmdEnabledLine3);
		if (WelcomeMsgCmdEnabledLine4 != "")
			Other.ClientMessage(WelcomeMsgCmdEnabledLine4);
		if (WelcomeMsgCmdEnabledLine5 != "")
			Other.ClientMessage(WelcomeMsgCmdEnabledLine5);
		if (WelcomeMsgCmdEnabledLine6 != "")
			Other.ClientMessage(WelcomeMsgCmdEnabledLine6);
	}
	else {
		if (WelcomeMsgCmdDisabledLine1 != "")
			Other.ClientMessage(WelcomeMsgCmdDisabledLine1);
		if (WelcomeMsgCmdDisabledLine2 != "")
			Other.ClientMessage(WelcomeMsgCmdDisabledLine2);
		if (WelcomeMsgCmdDisabledLine3 != "")
			Other.ClientMessage(WelcomeMsgCmdDisabledLine3);
		if (WelcomeMsgCmdDisabledLine4 != "")
			Other.ClientMessage(WelcomeMsgCmdDisabledLine4);
		if (WelcomeMsgCmdDisabledLine5 != "")
			Other.ClientMessage(WelcomeMsgCmdDisabledLine5);
		if (WelcomeMsgCmdDisabledLine6 != "")
			Other.ClientMessage(WelcomeMsgCmdDisabledLine6);
	}
}




// Old functions

/*
function ModifyPlayer(Pawn Other)
{
	if (!bGameStarted) { return; }

	if( (Other == None) || (Other.IsA('Bot')) || (Other.PlayerReplicationInfo == None) || (!bGameStarted)) { return; }

	if (Other.PlayerReplicationInfo.Team != 255)
	{
		StartTS(Other);
	}

	if (NextMutator != None)
	{
		NextMutator.ModifyPlayer(Other);
	}
}
*/

/*
function PostBeginPlay()
{
	if (!Initialised)
	{
		Initialised = true;
		Level.Game.RegisterMessageMutator(Self);
		bGameStarted = false;
		Enable('Tick');
		log("TeamspeakMutator running...");
	}
}
*/

/*
function StartTSR(Pawn p)
{
	local TeamspeakInfo a;
	local string params;

	params = "teamspeak://" $ Server $ ":" $ Port;
	params = params $ "?password=" $ Password;
	params = params $ "?nickname=" $ Prefix $ ConvertToNormalText(PlayerPawn(p).PlayerReplicationInfo.PlayerName);
	params = params $ "?channel=" $ Channel[0];
	if (ChannelPassword[0] != "")
	{
		params = params $ "?channelpassword=" $ ChannelPassword[0];
	}
	if (Subchannel[0] != "")
	{
		params = params $ "?subchannel=" $ Subchannel[0];
	}

	a = Spawn(class'TeamspeakInfo',p,,p.Location);
	if (a != None)
	{
		a.sURL = params;
		a.StartTS();
	}
}

function StartTSS(Pawn p)
{
	local TeamspeakInfo a;
	local string params;

	params = "teamspeak://" $ Server $ ":" $ Port;
	params = params $ "?password=" $ Password;
	params = params $ "?nickname=" $ Prefix $ ConvertToNormalText(PlayerPawn(p).PlayerReplicationInfo.PlayerName);
	params = params $ "?channel=" $ Channel[2];
	if (ChannelPassword[2] != "")
	{
		params = params $ "?channelpassword=" $ ChannelPassword[2];
	}
	if (Subchannel[2] != "")
	{
		params = params $ "?subchannel=" $ Subchannel[2];
	}

	a = Spawn(class'TeamspeakInfo',p,,p.Location);
	if (a != None)
	{
		a.sURL = params;
		a.StartTS();
	}
}

function StartTST(Pawn p)
{
	local TeamspeakInfo a;
	local string params;

	params = "teamspeak://" $ Server $ ":" $ Port;
	params = params $ "?password=" $ Password;
	params = params $ "?nickname=" $ Prefix $ ConvertToNormalText(PlayerPawn(p).PlayerReplicationInfo.PlayerName);
	params = params $ "?channel=" $ Channel[3];
	if (ChannelPassword[3] != "")
	{
		params = params $ "?channelpassword=" $ ChannelPassword[3];
	}
	if (Subchannel[3] != "")
	{
		params = params $ "?subchannel=" $ Subchannel[3];
	}

	a = Spawn(class'TeamspeakInfo',p,,p.Location);
	if (a != None)
	{
		a.sURL = params;
		a.StartTS();
	}
}

function StartTSB(Pawn p)
{
	local TeamspeakInfo a;
	local string params;

	params = "teamspeak://" $ Server $ ":" $ Port;
	params = params $ "?password=" $ Password;
	params = params $ "?nickname=" $ Prefix $ ConvertToNormalText(PlayerPawn(p).PlayerReplicationInfo.PlayerName);
	params = params $ "?channel=" $ Channel[1];
	if (ChannelPassword[1] != "")
	{
		params = params $ "?channelpassword=" $ ChannelPassword[1];
	}
	if (Subchannel[1] != "")
	{
		params = params $ "?subchannel=" $ Subchannel[1];
	}

	a = Spawn(class'TeamspeakInfo',p,,p.Location);
	if (a != None)
	{
		a.sURL = params;
		a.StartTS();
	}
}
*/

defaultproperties
{
     Server="smaankers.jepraatpoep.nl"
     Port=8767
     Channel="TitsClan-Fun"
     bEnableCommands=True
     WelcomeMsgCmdEnabledLine1="--------------------------  TeamSpeak Info:  ---------------------------"
     WelcomeMsgCmdEnabledLine2="Type MUTATE TEAMSPEAK to connect to your teamspeak channel or use MUTATE"
     WelcomeMsgCmdEnabledLine3="TSR (or TSB, TSS, TST) to go to the red, blue, spec or together channel"
     WelcomeMsgCmdEnabledLine4="Type MUTATE TCH FOO to go to channel foo"
     WelcomeMsgCmdEnabledLine5="---------------------------------------------------------------------------"
     WelcomeMsgCmdDisabledLine1="--------------------------  TeamSpeak Info:  ---------------------------"
     WelcomeMsgCmdDisabledLine2="Type MUTATE TEAMSPEAK to connect to your teamspeak channel"
     WelcomeMsgCmdDisabledLine3="---------------------------------------------------------------------------"
}
